﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="wuc_camera.ascx.cs" Inherits="TimeWork.user_control.wuc_camera" %>

<script src="../style/webcam/webcam.min.js"></script>
<script type="text/javascript">  
    $(document).ready(function () {
        configure();

    });


    // Configure a few settings and attach camera
    function configure() {
        Webcam.set({
            width: 400,
            height: 300,
            image_format: 'png',
            //jpeg_quality: 90
        });
        Webcam.attach('#my_camera');
        statusTimerID = setTimeout(function () {
            $('#btn_snapshot').prop('disabled', false);

        }, 1000);
    }

    // preload shutter audio clip
    var shutter = new Audio();
    shutter.autoplay = true;
    shutter.src = navigator.userAgent.match(/Firefox/) ? 'shutter.ogg' : 'shutter.mp3';

    function take_snapshot() {
        // play sound effect
        shutter.play();

        // take snapshot and get image data
        Webcam.snap(function (data_uri) {
            // display results in page
            //document.getElementById('results').innerHTML = '<img id="img_photo" src="' + data_uri + '"/>'; //imageprev
            //document.getElementById("imageid").src = "../template/save.png";
            $('#img_photo').attr('src', data_uri);
            $('#div_picture').removeClass("hide");
            $('#div_camera').addClass("hide");
            save();
        });
        Webcam.reset();
    }


    function save() {

        wait_();
        var formData = new FormData();
        formData.append('id', pic_id);
        formData.append('location', 'meet');
        formData.append('file', $('#img_photo').attr('src'));
        $.ajax({
            type: 'post',
            url: '../../service/cameraUploader.ashx',
            data: formData,
            success: function (response) {
                let json = $.parseJSON(response);

                if (json.message == "ok") {
                    call_fnc("'" + json.path + "'");
                }
                else {
                    alert_error(json.message);

                }

                unwait_();

            },
            processData: false,
            contentType: false,
            error: function (request, status, error) {
                alert_error(request.responseText + "\n" + status + "\n" + error);
                unwait_();
            }
        });

    }

</script>
<div>
    <div class="panel">

        <div id="div_camera">
            <div id="my_camera"></div>
        </div>
        <div id="div_picture" class="hide">
            <img id="img_photo" class="img_Upload" src="_" />
        </div>

    </div>
    <div class="toolbar-footer">
        <button id="btn_snapshot" type="button" class="btn btn-success" onclick="take_snapshot()" disabled="disabled"><span class="glyphicon glyphicon-camera"></span>&nbsp;&nbsp; عکس برداری</button>
    </div>
</div>
